//----Log-----------------
//Wrote Ver 1 Sept 26, without having different phases.
//Ver 1.1 September 28, 1995, added phases on Gosper's advice.
//Ver 1.2, Revised April 16, 1997.
//Version 2, added edit box to params dialog.
//Version 3, May 5, 97.
//-----------------
#include <windows.h>
#include <math.h>
#include "random.h" //for Randomize.  These are Rudy's randomize codes.
#include "bitmap6.hpp"
#include "resource.h"
#include "glock3.hpp"
//----------------Defines----
#define START_HAND_COUNT 5
#define ZOOMFACTOR 1.5
//---------Global Data------
HWND main_hwnd;
HINSTANCE main_hinst;
Frame main_frame;
WindowBitmap *wbm;
GosperClock *glock;
HWND hDlgParam = NULL;
HWND hDlgView = NULL;
HWND hDlgRand = NULL;
//--------Global Functions----
void WndUpdate(HWND); //This is the continually running thing.
LRESULT CALLBACK WndProc( HWND, unsigned int, unsigned int, LONG);
extern BOOL CALLBACK ParamDialogProc(HWND hDlg, UINT iMsg, WPARAM wParam,
	LPARAM lParam);
extern BOOL CALLBACK ViewDialogProc(HWND hDlg, UINT iMsg, WPARAM wParam,
	LPARAM lParam);
extern BOOL CALLBACK RandDialogProc(HWND hDlg, UINT iMsg, WPARAM wParam,
	LPARAM lParam);
//---------Windows Overhead------------
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
	LPSTR lpszCmdParam, int nCmdShow)
{
	static char szAppName[] = "Gosper Clock";
	HWND hwnd;
	MSG msg;
	WNDCLASS wndclass;

	if (!hPrevInstance)
	{
		wndclass.style = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc = WndProc;
		wndclass.cbClsExtra = 0;
		wndclass.cbWndExtra = 0;
		wndclass.hInstance = hInstance;
		wndclass.hIcon = LoadIcon( NULL, IDI_APPLICATION );
		wndclass.hCursor = LoadCursor( NULL, IDC_ARROW );
		wndclass.hbrBackground = GetStockObject(BLACK_BRUSH);
		wndclass.lpszMenuName = "Gosper";
		wndclass.lpszClassName = szAppName;
		RegisterClass (&wndclass);
	}

	hwnd = CreateWindow(szAppName,		// window class name
			"Gosper Clock, Ver 2.0, May 6, 1997, Copyright (C) Rudy Rucker",	// window caption
			WS_OVERLAPPEDWINDOW | WS_VSCROLL | WS_HSCROLL,	// window style
			CW_USEDEFAULT,				// initial x position
			CW_USEDEFAULT,				// initial y position
			CW_USEDEFAULT,				// initial x size
			CW_USEDEFAULT,				// initial y size
			NULL,					// parent window handle
			NULL,					// window menu handle
			hInstance,				// program instance handle
			NULL);					// creation parameters

   //Put these guys up as globals for future use.
	main_hwnd = hwnd;
	main_hinst = hInstance;

	ShowWindow(hwnd, nCmdShow);
	UpdateWindow(hwnd);

	while (TRUE) //Keep it growing.  See Petzold's RANDRECT example.
	{
		if ( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) )
		{
				if (!(
					(hDlgParam && IsDialogMessage(hDlgParam, &msg))
					||(hDlgView && IsDialogMessage(hDlgView, &msg))
					||(hDlgRand && IsDialogMessage(hDlgRand, &msg))
/* As you add more dialogs, insert more lines like the following:
					|| (hdlg??? && IsDialogMessage(hdlg???, &msg))
*/
				))
				{
					if (msg.message == WM_QUIT)
						break;
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
		}
		else
			WndUpdate(hwnd);
	}
	return msg.wParam;
}

//-------------------Message Processing--------
long FAR PASCAL WndProc( HWND hwnd, unsigned int message, unsigned int wParam, LONG lParam)
{
	HDC hdc;
	PAINTSTRUCT ps;
#ifndef __FLAT__ //16 bit version, means Borland 4.5
	static FARPROC lpfnParamDialogProc;
	static FARPROC lpfnViewDialogProc;
	static FARPROC lpfnRandDialogProc;
#endif //not __FLAT__
	//Begin commdlg stuff
	static OPENFILENAME ofn;
	#define MAXFILENAME 256
	/* maximum length of file with pathname      */
	static char szFilterSpecGOS [128] =
		"GOS Files (*.GOS)\0All Files (*.*)\0*.*\0";
	static char szFileName[MAXFILENAME];
	static char szFileTitle[MAXFILENAME];
//End commdlg stuff


	switch (message)
	{
		case WM_CREATE:
			Randomize(); //Seed with the time, so different runs differ.
			glock = new GosperClock(START_HAND_COUNT);
			glock->SetRadius(main_frame);  //calls Frame::SetRealWindow
			wbm = new WindowBitmap(hwnd, RGB(0, 0, 0)); //Black backg.
			main_frame.SetFixedAspect(TRUE);
#ifndef __FLAT__ //16 bit version, means Borland 4.5
			lpfnParamDialogProc = MakeProcInstance((FARPROC)ParamDialogProc, main_hinst);
			lpfnViewDialogProc = MakeProcInstance((FARPROC)ViewDialogProc, main_hinst);
			lpfnRandDialogProc = MakeProcInstance((FARPROC)RandDialogProc, main_hinst);
#endif //not __FLAT__
			strcpy(szFileName,"*.GOS");
			// fill in non-variant fields of OPENFILENAME struct.
			ofn.lStructSize       = sizeof(OPENFILENAME);
			ofn.hwndOwner	  = hwnd;
			ofn.lpstrFilter	  = szFilterSpecGOS;
			ofn.lpstrCustomFilter = NULL;
			ofn.nMaxCustFilter	  = 0;
			ofn.nFilterIndex	  = 1;
			ofn.lpstrFile         = NULL; //Set in Open and Save
			ofn.nMaxFile	  = MAXFILENAME;
			ofn.lpstrInitialDir   = NULL;
			ofn.lpstrFileTitle    = NULL; //Set in Open and Save
			ofn.nMaxFileTitle     = MAXFILENAME;
			ofn.lpstrTitle        = NULL;
			ofn.lpstrDefExt       = "GOS";
			ofn.Flags             = 0; //Set in Open and Save
			return 0;

		case WM_PAINT:
			hdc = BeginPaint(hwnd, &ps);
			wbm->CopyTo(hdc, ps.rcPaint);
			EndPaint(hwnd, &ps);
			return 0;

		case WM_SIZE:
			/*lParam holds the extent in pixels of the resized window. */
			main_frame.SetPixelWindow(LOWORD(lParam), HIWORD(lParam));
			return 0;

		case WM_LBUTTONDOWN:
			main_frame.ZoomAtPixel(LOWORD(lParam), HIWORD(lParam), 1/ZOOMFACTOR);
			wbm->Clear(); //Clear the memory bitmap
			return 0;

		case WM_RBUTTONDOWN:
			main_frame.ZoomAtPixel(LOWORD(lParam), HIWORD(lParam), ZOOMFACTOR);
			wbm->Clear(); //Clear the memory bitmap
			return 0;

		case WM_COMMAND:
			switch(wParam)
			{
				case IDM_RESET:
					wbm->Clear();
					glock->Reset();
					glock->SetRadius(main_frame);
					break;
				case IDM_OPEN:
					strcpy(szFileName,"*.GOS");
					ofn.lpstrFile = szFileName;
					ofn.lpstrFileTitle = szFileTitle;
					ofn.Flags = 0;
					if( GetOpenFileName((LPOPENFILENAME)&ofn) )
					{
						SetCursor(LoadCursor(NULL, IDC_WAIT)); // Wait, I'm working!
 						glock->Open(szFileName); 
						InvalidateRect(hwnd, NULL, FALSE); //Get rid of pick rect
						SetCursor(LoadCursor(NULL, IDC_ARROW)); //I'm done!
						glock->SetRadius(main_frame);
						if (hDlgParam)
							SendMessage(hDlgParam, WM_COMMAND, PD_UPDATE, 0L);
         			}
					break;
				case IDM_SAVE:
					strcpy(szFileName,"*.GOS");
					ofn.lpstrFile = szFileName;
					ofn.lpstrFileTitle = szFileTitle;
					ofn.Flags = OFN_OVERWRITEPROMPT;
					if( GetSaveFileName(&ofn) )
					{
 						SetCursor(LoadCursor(NULL, IDC_WAIT)); // Wait, I'm working!
 						glock->Save(szFileName);
						SetCursor(LoadCursor(NULL, IDC_ARROW)); //I'm done!
					}
					break;
				case IDM_PARAM:
/* As the second argument to CreateDialog, you give the name of the dialog.  The
name is not case sensitive.  The name must appear here in quotes, and it must
appear without quotes in the *.RC file in a line of the form
Param DIALOG .... */
					if (!hDlgParam)
					{
#ifdef __FLAT__ //32 bit version
						hDlgParam = CreateDialog(main_hinst,
							"Param", hwnd, (DLGPROC)ParamDialogProc);
#else //16 bit, Borland 4.5
						hDlgParam = CreateDialog(main_hinst,
							"Param", hwnd, lpfnParamDialogProc);
#endif //not __FLAT__
						ShowWindow(hDlgParam, TRUE);
					}
					break;
				case IDM_RAND:
					if (!hDlgRand)
					{
#ifdef __FLAT__ //32 bit version
						hDlgRand = CreateDialog(main_hinst,
							"Rand", hwnd, (DLGPROC)RandDialogProc);
#else //16 bit, Borland 4.5
						hDlgRand = CreateDialog(main_hinst,
							"Rand", hwnd, lpfnRandDialogProc);
#endif //not __FLAT__
						ShowWindow(hDlgRand, TRUE);
					}
					break;
				case IDM_VIEW:
					if (!hDlgView)
					{
#ifdef __FLAT__ //32 bit version
						hDlgView = CreateDialog(main_hinst,
							"View", hwnd, (DLGPROC)ViewDialogProc);
#else //16 bit, Borland 4.5
						hDlgView = CreateDialog(main_hinst,
							"View", hwnd, lpfnViewDialogProc);
#endif //not __FLAT__
						ShowWindow(hDlgView, TRUE);
					}
					break;
				case IDM_EXIT:
					SendMessage( hwnd, WM_DESTROY, 0, 0L ); //Goes to WndProc.
					break;
			}
			return 0;

		case WM_DESTROY:
			delete glock;
			delete wbm;
			PostQuitMessage(0);
//Copy this block of code for each modeless dialog box
         if (hDlgParam)
				DestroyWindow(hDlgParam);
#ifndef __FLAT__ //16 bit version, means Borland 4.5
			FreeProcInstance(lpfnParamDialogProc);
#endif //not __FLAT__
//Copy this block of code for each modeless dialog box
         if (hDlgView)
				DestroyWindow(hDlgView);
#ifndef __FLAT__ //16 bit version, means Borland 4.5
			FreeProcInstance(lpfnViewDialogProc);
#endif //not __FLAT__
//Copy this block of code for each modeless dialog box
         if (hDlgRand)
				DestroyWindow(hDlgRand);
#ifndef __FLAT__ //16 bit version, means Borland 4.5
			FreeProcInstance(lpfnRandDialogProc);
#endif //not __FLAT__
			return 0;
	}
	return DefWindowProc(hwnd, message, wParam, lParam);
}
//-------------------The Action--------------
void WndUpdate(HWND hwnd)
{
	glock->RealToPixel(main_frame); //Convert hands to pixel coordinates.
	if (glock->writemode()) //Assume nonzero means erase.
		wbm->Clear(); //Clear the memory bitmap
	glock->Draw(wbm->hdc()); //Draw the clock in the memory bitmap.
	InvalidateRect(hwnd, NULL, FALSE); //BitBlt memory bitmap to window.
	glock->Tick(); //Update clock position.
}
